/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.dom;

import java.awt.Color;
import java.awt.Component;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TooManyListenersException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.autoplot.AutoplotUtil;
import org.autoplot.MouseModuleType;
import org.autoplot.RenderType;
import org.autoplot.RenderTypeUtil;
import org.autoplot.datasource.URISplit;
import org.autoplot.dom.Application;
import org.autoplot.dom.ApplicationController;
import org.autoplot.dom.Axis;
import org.autoplot.dom.AxisController;
import org.autoplot.dom.BindingModel;
import org.autoplot.dom.Canvas;
import org.autoplot.dom.ChangesSupport;
import org.autoplot.dom.Column;
import org.autoplot.dom.DataSourceFilter;
import org.autoplot.dom.DomNode;
import org.autoplot.dom.DomNodeController;
import org.autoplot.dom.DomUtil;
import org.autoplot.dom.LabelConverter;
import org.autoplot.dom.Plot;
import org.autoplot.dom.PlotElement;
import org.autoplot.dom.Row;
import org.autoplot.tca.DataSourceTcaSource;
import org.autoplot.util.TickleTimer;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.datum.format.DateTimeDatumFormatter;
import org.das2.datum.format.DatumFormatter;
import org.das2.event.BoxZoomMouseModule;
import org.das2.event.DasMouseInputAdapter;
import org.das2.event.MouseModule;
import org.das2.event.ZoomPanMouseModule;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasColorBar;
import org.das2.graph.DasColumn;
import org.das2.graph.DasDevicePosition;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.Renderer;
import org.das2.graph.SeriesRenderer;
import org.das2.graph.SpectrogramRenderer;
import org.das2.graph.TickVDescriptor;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.QFunction;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.util.LoggerManager;
import org.jdesktop.beansbinding.Converter;

public final class PlotController
extends DomNodeController {
    Application dom;
    Plot plot;
    private DasPlot dasPlot;
    private DasColorBar dasColorBar;
    private LabelConverter titleConverter;
    private DatumRange scanPrevRange = null;
    private DatumRange scanNextRange = null;
    public List<PlotElement> pdListen = new LinkedList<PlotElement>();
    private static final String PENDING_ADD_DAS_PEER = "addDasPeer";
    private static final Logger logger = LoggerManager.getLogger((String)"autoplot.dom.plotcontroller");
    public PropertyChangeListener rowColListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LoggerManager.logPropertyChangeEvent((PropertyChangeEvent)evt);
            if (PlotController.this.dasPlot != null && evt.getPropertyName().equals("rowId")) {
                Row row;
                String id = (String)evt.getNewValue();
                Row row2 = row = id.length() == 0 ? null : (Row)DomUtil.getElementById(PlotController.this.dom, id);
                if (row == null) {
                    row = PlotController.this.dom.controller.getCanvas().marginRow;
                }
                DasRow dasRow = row.controller.getDasRow();
                PlotController.this.dasPlot.setRow(dasRow);
                PlotController.this.plot.getXaxis().getController().getDasAxis().setRow(dasRow);
                PlotController.this.plot.getYaxis().getController().getDasAxis().setRow(dasRow);
                PlotController.this.plot.getZaxis().getController().getDasAxis().setRow(dasRow);
            } else if (PlotController.this.dasPlot != null && evt.getPropertyName().equals("columnId")) {
                Column col;
                String id = (String)evt.getNewValue();
                Column column = col = id.length() == 0 ? null : (Column)DomUtil.getElementById(PlotController.this.dom, id);
                if (col == null) {
                    col = PlotController.this.dom.controller.getCanvas().marginColumn;
                }
                DasColumn dasColumn = col.controller.getDasColumn();
                PlotController.this.dasPlot.setColumn(dasColumn);
                DasColumn oldColorbarColumn = PlotController.this.plot.getZaxis().getController().getDasAxis().getColumn();
                PlotController.this.plot.getXaxis().getController().getDasAxis().setColumn(dasColumn);
                PlotController.this.plot.getYaxis().getController().getDasAxis().setColumn(dasColumn);
                DasColumn c = DasColorBar.getColorBarColumn((DasColumn)dasColumn);
                PlotController.this.dasColorBar.setColumn(c);
                oldColorbarColumn.removeListeners();
            }
        }
    };
    public static final String PROP_AUTOBINDING = "autoBinding";
    protected boolean autoBinding = true;
    private PropertyChangeListener labelListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LoggerManager.logPropertyChangeEvent((PropertyChangeEvent)evt, (String)"labelListener");
            if (evt.getPropertyName().equals("title")) {
                PlotController.this.plot.setAutoLabel(false);
            }
        }
    };
    private PropertyChangeListener ticksURIListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LoggerManager.logPropertyChangeEvent((PropertyChangeEvent)evt, (String)"ticksURIListener");
            if (evt.getPropertyName().equals("ticksURI")) {
                String control = (String)evt.getNewValue();
                if (control.length() == 0) {
                    PlotController.this.plot.getXaxis().getController().getDasAxis().setDataPath("");
                    PlotController.this.plot.getXaxis().getController().getDasAxis().setDrawTca(false);
                    PlotController.this.plot.getXaxis().setLabel("");
                } else if (Ops.isSafeName((String)control)) {
                    DomNode n = PlotController.this.dom.getElementById(control);
                    if (n instanceof DataSourceFilter) {
                        DataSourceFilter dsf = (DataSourceFilter)n;
                        try {
                            DataSourceTcaSource f = new DataSourceTcaSource(dsf);
                            PlotController.this.plot.getXaxis().getController().getDasAxis().setTcaFunction((QFunction)f);
                            PlotController.this.plot.getXaxis().getController().getDasAxis().setDrawTca(true);
                            PlotController.this.plot.getXaxis().setLabel("%{RANGE}");
                        }
                        catch (Exception ex) {
                            PlotController.this.plot.getXaxis().getController().getDasAxis().setDataPath("");
                            PlotController.this.plot.getXaxis().getController().getDasAxis().setDrawTca(false);
                            PlotController.this.plot.getXaxis().setLabel("Error with init using " + control);
                        }
                    } else {
                        PlotController.this.plot.getXaxis().getController().getDasAxis().setDataPath("");
                        PlotController.this.plot.getXaxis().getController().getDasAxis().setDrawTca(false);
                        PlotController.this.plot.getXaxis().setLabel("node must be data source");
                    }
                } else {
                    logger.log(Level.FINE, "prop_ticks_uri={0}", evt.getNewValue());
                    String dasAddress = "class:org.autoplot.tca.UriTcaSource:" + evt.getNewValue();
                    PlotController.this.plot.getXaxis().getController().getDasAxis().setDataPath(dasAddress);
                    PlotController.this.plot.getXaxis().getController().getDasAxis().setDrawTca(true);
                    PlotController.this.plot.getXaxis().setLabel("%{RANGE}");
                }
            }
        }
    };
    private PropertyChangeListener idListener = new PropertyChangeListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LoggerManager.logPropertyChangeEvent((PropertyChangeEvent)evt, (String)"idListener");
            if (PlotController.this.dom.controller.isValueAdjusting()) {
                return;
            }
            ChangesSupport.DomLock lock = PlotController.this.dom.controller.mutatorLock();
            lock.lock("Changing plot id");
            try {
                for (BindingModel b : PlotController.this.dom.getBindings()) {
                    if (b.getSrcId().equals(evt.getOldValue())) {
                        b.srcId = (String)evt.getNewValue();
                    }
                    if (!b.getDstId().equals(evt.getOldValue())) continue;
                    b.dstId = (String)evt.getNewValue();
                }
                for (PlotElement pe : PlotController.this.dom.plotElements) {
                    if (!pe.getPlotId().equals(evt.getOldValue())) continue;
                    pe.setPlotId((String)evt.getNewValue());
                }
            }
            finally {
                lock.unlock();
            }
        }
    };
    private PropertyChangeListener dayOfYearListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LoggerManager.logPropertyChangeEvent((PropertyChangeEvent)evt, (String)"dayOfYearListener");
            DasAxis update = PlotController.this.plot.getXaxis().controller.dasAxis;
            PlotController.this.updateAxisFormatter(update);
        }
    };
    private PropertyChangeListener mouseModuleListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LoggerManager.logPropertyChangeEvent((PropertyChangeEvent)evt, (String)"mouseModuleListener");
            DasPlot p = PlotController.this.dasPlot;
            MouseModuleType mm = (MouseModuleType)((Object)evt.getNewValue());
            MouseModule m = null;
            if (null != mm) {
                switch (mm) {
                    case boxZoom: {
                        m = p.getDasMouseInputAdapter().getModuleByLabel("Box Zoom");
                        break;
                    }
                    case crosshairDigitizer: {
                        m = p.getDasMouseInputAdapter().getModuleByLabel("Crosshair Digitizer");
                        break;
                    }
                    case zoomX: {
                        m = p.getDasMouseInputAdapter().getModuleByLabel("Zoom X");
                        break;
                    }
                }
            }
            if (m != null) {
                p.getDasMouseInputAdapter().setPrimaryModule(m);
            } else {
                logger.log(Level.WARNING, "logger note recognized: {0}", (Object)mm);
            }
        }
    };
    private PropertyChangeListener autorangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LoggerManager.logPropertyChangeEvent((PropertyChangeEvent)evt, (String)"autorangeListener");
            if (PlotController.this.dom.getController().isValueAdjusting()) {
                logger.fine("autorangeListener cannot work while isValueAdjusting");
                return;
            }
            if (PlotController.this.dom.options.autoranging) {
                if (evt.getPropertyName().equals("autoRange") && evt.getNewValue().equals(Boolean.TRUE)) {
                    PlotController.this.resetZoom(PlotController.this.getPlot().getXaxis().isAutoRange(), PlotController.this.getPlot().getYaxis().isAutoRange(), PlotController.this.getPlot().getZaxis().isAutoRange());
                } else if (evt.getPropertyName().equals("autoRangeHints")) {
                    PlotController.this.resetZoom(PlotController.this.getPlot().getXaxis().isAutoRange(), PlotController.this.getPlot().getYaxis().isAutoRange(), PlotController.this.getPlot().getZaxis().isAutoRange());
                } else if (evt.getPropertyName().equals("range") && !evt.getNewValue().equals(evt.getOldValue())) {
                    PlotController.this.redoAutoranging();
                }
            }
        }
    };
    PropertyChangeListener xaxisRangeListener;
    private PropertyChangeListener plotListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            block6: {
                if (evt.getPropertyName().equals("colorbarColumnPosition")) {
                    try {
                        DasDevicePosition.parseLayoutStr((DasDevicePosition)PlotController.this.dasColorBar.getColumn(), (String)((String)evt.getNewValue()));
                    }
                    catch (ParseException ex) {
                        logger.log(Level.WARNING, "unable to parse value: {0}", evt.getNewValue());
                        String val = DasDevicePosition.formatLayoutStr((DasDevicePosition)PlotController.this.dasColorBar.getColumn());
                        if (val.equals(evt.getNewValue())) break block6;
                        PlotController.this.plot.setColorbarColumnPosition(val);
                    }
                }
            }
            if (PlotController.this.titleConverter == null) {
                return;
            }
            if (PlotController.this.plot.getTitle().length() == 0) {
                PlotController.this.dasPlot.setTitle("");
            } else {
                PlotController.this.dasPlot.setTitle((String)PlotController.this.titleConverter.convertForward(PlotController.this.plot.getTitle()));
            }
        }
    };
    private PropertyChangeListener listener = new PropertyChangeListener(){

        public String toString() {
            return "" + PlotController.this;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LoggerManager.logPropertyChangeEvent((PropertyChangeEvent)evt, (String)"listener");
            if (evt.getSource() instanceof DasAxis) {
                DasAxis axis = (DasAxis)evt.getSource();
                Axis domAxis = PlotController.this.getDomAxis(axis);
                if (domAxis == null) {
                    return;
                }
                if (evt.getPropertyName().equals("Frame.active")) {
                    return;
                }
                if ((evt.getPropertyName().equals("units") || evt.getPropertyName().equals("datumRange")) && axis.isDrawTca() && domAxis.getLabel().length() == 0) {
                    domAxis.setLabel("%{RANGE}");
                }
                if (evt.getPropertyName().equals("units") || evt.getPropertyName().equals("datumRange") || evt.getPropertyName().equals("label")) {
                    PlotController.this.updateAxisFormatter(axis);
                }
            } else if (evt.getPropertyName().equals("focusRenderer")) {
                List<PlotElement> eles = PlotController.this.dom.controller.getPlotElementsFor(PlotController.this.plot);
                PlotElement fe = null;
                for (PlotElement ele : eles) {
                    if (ele.getController().getRenderer() != evt.getNewValue()) continue;
                    fe = ele;
                }
                if (fe != null) {
                    PlotController.this.dom.controller.setPlotElement(fe);
                }
            }
        }
    };
    private final PropertyChangeListener plotDefaultsListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LoggerManager.logPropertyChangeEvent((PropertyChangeEvent)evt, (String)"plotDefaultsListener");
            PlotElement pele = (PlotElement)evt.getSource();
            List<PlotElement> pp = PlotController.this.dom.getController().getPlotElementsFor(PlotController.this.plot);
            if (!pp.contains(pele)) {
                return;
            }
            pp.remove(pele);
            if (pele.isAutoRenderType() && pp.isEmpty()) {
                PlotController.this.setAutoBinding(true);
            }
            PlotController.this.doPlotElementDefaultsChange(pele);
        }
    };
    private final PropertyChangeListener renderTypeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LoggerManager.logPropertyChangeEvent((PropertyChangeEvent)evt, (String)"renderTypeListener");
            PlotController.this.checkRenderType();
        }
    };
    PlotElement plotElement;
    private final PropertyChangeListener plotElementDataSetListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LoggerManager.logPropertyChangeEvent((PropertyChangeEvent)evt, (String)"plotElementDataSetListener");
            if (PlotController.this.plotElement == null) {
                System.err.println("whoops, getting there");
                return;
            }
            if (PlotController.this.titleConverter == null) {
                return;
            }
            QDataSet ds1 = ((PlotController)PlotController.this).titleConverter.plotElement != null ? ((PlotController)PlotController.this).titleConverter.plotElement.getController().getDataSet() : null;
            logger.log(Level.FINE, "titleConverter should use for dataset: {0}", ds1);
            String t = (String)PlotController.this.titleConverter.convertForward(PlotController.this.plot.getTitle());
            PlotController.this.dasPlot.setTitle(t);
            AxisController xaxisController = PlotController.this.plot.getXaxis().getController();
            AxisController yaxisController = PlotController.this.plot.getYaxis().getController();
            AxisController zaxisController = PlotController.this.plot.getZaxis().getController();
            if (xaxisController == null || yaxisController == null || zaxisController == null) {
                return;
            }
            LabelConverter xaxisLabelConverter = xaxisController.labelConverter;
            LabelConverter yaxisLabelConverter = yaxisController.labelConverter;
            LabelConverter zaxisLabelConverter = zaxisController.labelConverter;
            if (xaxisLabelConverter == null || yaxisLabelConverter == null || zaxisLabelConverter == null) {
                return;
            }
            PlotController.this.dasPlot.getYAxis().setLabel((String)yaxisLabelConverter.convertForward(PlotController.this.plot.getYaxis().getLabel()));
            PlotController.this.dasPlot.getXAxis().setLabel((String)xaxisLabelConverter.convertForward(PlotController.this.plot.getXaxis().getLabel()));
            PlotController.this.dasColorBar.setLabel((String)zaxisLabelConverter.convertForward(PlotController.this.plot.getZaxis().getLabel()));
            QDataSet pds = PlotController.this.plotElement.getController().getDataSet();
            PlotController.this.setActiveDataSet(pds);
            logger.log(Level.FINE, "{0} dataSetListener", PlotController.this.plot);
            if (pds != null && UnitsUtil.isIntervalOrRatioMeasurement((Units)SemanticOps.getUnits((QDataSet)pds))) {
                PlotController.this.updateNextPrevious(PlotController.this.plot.getXaxis().getRange(), pds);
            }
        }

        public String toString() {
            return "plotElementDataSetListener for " + PlotController.this.getPlot().getId();
        }
    };
    private QDataSet activeDataSet = null;
    public static final String PROP_ACTIVEDATASET = "activeDataSet";
    protected JMenuItem plotElementPropsMenuItem = null;
    public static final String PROP_PLOTELEMENTPROPSMENUITEM = "plotElementPropsMenuItem";
    private JMenuItem[] expertMenuItems;

    public PlotController(Application dom, Plot domPlot, DasPlot dasPlot, DasColorBar colorbar) {
        this(dom, domPlot);
        this.dasPlot = dasPlot;
        this.dasColorBar = colorbar;
        dasPlot.addPropertyChangeListener(this.listener);
        dasPlot.getXAxis().addPropertyChangeListener(this.listener);
        dasPlot.getYAxis().addPropertyChangeListener(this.listener);
    }

    public PlotController(Application dom, Plot plot) {
        super(plot);
        this.dom = dom;
        this.plot = plot;
        this.plot.addPropertyChangeListener("title", this.labelListener);
        this.plot.addPropertyChangeListener("ticksURI", this.ticksURIListener);
        this.plot.addPropertyChangeListener("id", this.idListener);
        this.plot.getXaxis().addPropertyChangeListener(this.autorangeListener);
        this.plot.getYaxis().addPropertyChangeListener(this.autorangeListener);
        this.plot.getZaxis().addPropertyChangeListener(this.autorangeListener);
        dom.options.addPropertyChangeListener("dayOfYear", this.dayOfYearListener);
        dom.options.addPropertyChangeListener("mouseModule", this.mouseModuleListener);
        plot.controller = this;
    }

    public Plot getPlot() {
        return this.plot;
    }

    public boolean isAutoBinding() {
        return this.autoBinding;
    }

    public void setAutoBinding(boolean autoBinding) {
        boolean oldAutoBinding = this.autoBinding;
        this.autoBinding = autoBinding;
        this.propertyChangeSupport.firePropertyChange(PROP_AUTOBINDING, oldAutoBinding, autoBinding);
    }

    private void redoAutoranging() {
        boolean alwaysAutorange = false;
        if (alwaysAutorange) {
            boolean mustAutoRange;
            System.err.println(String.format("line307 %s %s %s", this.getPlot().getXaxis().isAutoRange(), this.getPlot().getYaxis().isAutoRange(), this.getPlot().getZaxis().isAutoRange()));
            boolean bl = mustAutoRange = this.getPlot().getXaxis().isAutoRange() || this.getPlot().getYaxis().isAutoRange();
            if (mustAutoRange) {
                List<PlotElement> pes = this.getApplication().getController().getPlotElementsFor(this.plot);
                for (PlotElement pe : pes) {
                    try {
                        QDataSet b = AutoplotUtil.bounds(pe.getController().getDataSet(), pe.getRenderType());
                        if (this.getPlot().getYaxis().isAutoRange()) {
                            pe.getPlotDefaults().getYaxis().setRange(DataSetUtil.asDatumRange((QDataSet)b.slice(1)));
                        }
                        if (!this.getPlot().getXaxis().isAutoRange()) continue;
                        pe.getPlotDefaults().getXaxis().setRange(DataSetUtil.asDatumRange((QDataSet)b.slice(0)));
                    }
                    catch (Exception ex) {
                        logger.log(Level.SEVERE, null, ex);
                    }
                }
                this.resetZoom(this.getPlot().getXaxis().isAutoRange(), this.getPlot().getYaxis().isAutoRange(), this.getPlot().getZaxis().isAutoRange());
            }
        }
    }

    private static boolean validBounds(QDataSet bounds) {
        QDataSet wds = DataSetUtil.weightsDataSet((QDataSet)bounds);
        return wds.value(0) != 0.0 && wds.value(1) != 0.0;
    }

    private void updateNextPrevious(final DatumRange dr0, QDataSet ds) {
        logger.log(Level.FINE, "updateNextPrevious: {0}", dr0);
        if (ds != null && SemanticOps.isBundle((QDataSet)ds)) {
            logger.log(Level.FINE, "unbundling: {0}", ds);
            QDataSet xds = SemanticOps.xtagsDataSet((QDataSet)ds);
            ds = ds.rank() == 2 ? Ops.unbundle((QDataSet)ds, (int)(ds.length(0) - 1)) : SemanticOps.getDependentDataSet((QDataSet)ds);
            ds = Ops.link((QDataSet)xds, (QDataSet)ds);
        }
        if (ds != null && (ds.rank() == 0 || ds.length() > 10000000)) {
            logger.fine("simple next and previous used because data is very large");
            this.scanPrevRange = dr0.previous();
            this.scanNextRange = dr0.next();
        } else {
            this.scanPrevRange = DataSetUtil.getPreviousInterval((QDataSet)ds, (DatumRange)dr0);
            this.scanNextRange = DataSetUtil.getNextInterval((QDataSet)ds, (DatumRange)dr0);
        }
        double rescaleFactor = this.scanPrevRange.width().divide(dr0.width()).value();
        if (rescaleFactor < 0.1 || rescaleFactor > 10.0) {
            logger.log(Level.WARNING, "scan prev fails to find acceptable range: {0} -> {1} rescaleFactor={2}", new Object[]{dr0, this.scanPrevRange, rescaleFactor});
            this.scanPrevRange = dr0.previous();
        }
        if ((rescaleFactor = this.scanNextRange.width().divide(dr0.width()).value()) < 0.1 || rescaleFactor > 10.0) {
            logger.log(Level.WARNING, "scan next fails to find acceptable range: {0} -> {1} rescaleFactor={2}", new Object[]{dr0, this.scanNextRange, rescaleFactor});
            this.scanNextRange = dr0.next();
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                String amount;
                Plot p = PlotController.this.getPlot();
                if (p == null) {
                    return;
                }
                Axis a = p.getXaxis();
                if (a == null) {
                    return;
                }
                AxisController c = a.getController();
                if (c == null) {
                    return;
                }
                DasAxis da = c.getDasAxis();
                if (da == null) {
                    return;
                }
                if (PlotController.this.scanNextRange.min().equals(dr0.max())) {
                    da.setNextActionLabel("step >>", "<html>step to next interval<br>" + PlotController.this.scanNextRange);
                } else {
                    amount = PlotController.this.scanNextRange.min().subtract(dr0.min()).toString();
                    da.setNextActionLabel("scan >>", "<html>scan " + amount + " to <br>" + PlotController.this.scanNextRange);
                }
                if (PlotController.this.scanPrevRange.max().equals(dr0.min())) {
                    da.setPreviousActionLabel("<< step", "<html>step to previous interval<br>" + PlotController.this.scanPrevRange);
                } else {
                    amount = PlotController.this.scanPrevRange.min().subtract(dr0.min()).abs().toString();
                    da.setPreviousActionLabel("<< scan", "<html>scan " + amount + " to <br>" + PlotController.this.scanPrevRange);
                }
            }
        };
        SwingUtilities.invokeLater(run);
    }

    protected void createDasPeer(final Canvas canvas, final Row domRow, final Column domColumn) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                PlotController.this.createDasPeerImmediately(canvas, domRow, domColumn);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(run);
            }
            catch (InterruptedException | InvocationTargetException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
    }

    private void createDasPeerImmediately(Canvas canvas, Row domRow, Column domColumn) {
        Application application = this.dom;
        DatumRange x = this.plot.xaxis.range;
        DatumRange y = this.plot.yaxis.range;
        final DasAxis xaxis = new DasAxis(x.min(), x.max(), 2);
        DasAxis yaxis = new DasAxis(y.min(), y.max(), 3);
        xaxis.setEnableHistory(false);
        yaxis.setEnableHistory(false);
        final TickleTimer nextPrevTickleTimer = new TickleTimer(300L, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DatumRange dr = xaxis.getDatumRange();
                List<PlotElement> pele = PlotController.this.getApplication().getController().getPlotElementsFor(PlotController.this.plot);
                QDataSet ds = pele.size() > 0 ? pele.get(0).getController().getDataSet() : null;
                PlotController.this.updateNextPrevious(dr, ds);
            }
        });
        this.xaxisRangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LoggerManager.logPropertyChangeEvent((PropertyChangeEvent)evt, (String)"xaxis datumrange");
                if (PlotController.this.dom.getOptions().isScanEnabled()) {
                    nextPrevTickleTimer.tickle();
                }
            }
        };
        xaxis.addPropertyChangeListener("datumRange", this.xaxisRangeListener);
        AbstractAction nextListener = new AbstractAction("scannext"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                List<PlotElement> pele = PlotController.this.getApplication().getController().getPlotElementsFor(PlotController.this.plot);
                DatumRange dr = xaxis.getDatumRange();
                if (pele.isEmpty() || PlotController.this.scanNextRange == null) {
                    xaxis.setDatumRange(dr.next());
                } else {
                    dr = PlotController.this.scanNextRange;
                    if (!dr.min().equals(xaxis.getDatumRange().max())) {
                        xaxis.setAnimated(true);
                        xaxis.setDataRange(dr.min(), dr.max());
                        xaxis.setAnimated(false);
                    }
                    xaxis.setDatumRange(dr);
                }
            }
        };
        xaxis.setNextAction("scan", nextListener);
        AbstractAction prevListener = new AbstractAction("scanprev"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent((ActionEvent)e);
                List<PlotElement> pele = PlotController.this.getApplication().getController().getPlotElementsFor(PlotController.this.plot);
                DatumRange dr = xaxis.getDatumRange();
                if (pele.isEmpty() || PlotController.this.scanPrevRange == null) {
                    xaxis.setDatumRange(dr.previous());
                } else {
                    dr = PlotController.this.scanPrevRange;
                    if (xaxis.isLog() && dr.min().value() <= 0.0) {
                        logger.fine("cannot scan to non-positive with log xaxis");
                        return;
                    }
                    if (!dr.max().equals(xaxis.getDatumRange().min())) {
                        xaxis.setAnimated(true);
                        xaxis.setDataRange(dr.min(), dr.max());
                        xaxis.setAnimated(false);
                    }
                    xaxis.setDatumRange(dr);
                }
            }
        };
        xaxis.setPreviousAction("scan", prevListener);
        if (UnitsUtil.isTimeLocation((Units)xaxis.getUnits())) {
            xaxis.setUserDatumFormatter((DatumFormatter)new DateTimeDatumFormatter(this.dom.getController().getApplication().getOptions().isDayOfYear() ? 1 : 0));
        } else {
            xaxis.setUserDatumFormatter(null);
        }
        if (UnitsUtil.isTimeLocation((Units)yaxis.getUnits())) {
            yaxis.setUserDatumFormatter((DatumFormatter)new DateTimeDatumFormatter(this.dom.getController().getApplication().getOptions().isDayOfYear() ? 1 : 0));
        } else {
            yaxis.setUserDatumFormatter(null);
        }
        this.plot.setRowId(domRow.getId());
        DasRow row = domRow.controller.getDasRow();
        this.plot.addPropertyChangeListener("rowId", this.rowColListener);
        this.plot.addPropertyChangeListener("columnId", this.rowColListener);
        DasColumn col = domColumn.controller.getDasColumn();
        DasPlot dasPlot1 = new DasPlot(xaxis, yaxis);
        dasPlot1.setPreviewEnabled(true);
        dasPlot1.setDrawGridOver(false);
        DatumRange colorRange = new DatumRange(0.0, 100.0, Units.dimensionless);
        DasColorBar colorbar = new DasColorBar(colorRange.min(), colorRange.max(), false);
        colorbar.addFocusListener((FocusListener)application.controller.focusAdapter);
        colorbar.setFillColor(new Color(0, true));
        colorbar.setEnableHistory(false);
        DasCanvas dasCanvas = canvas.controller.getDasCanvas();
        dasCanvas.add((DasCanvasComponent)dasPlot1, row, col);
        dasPlot1.getXAxis().setPlot(dasPlot1);
        dasPlot1.getYAxis().setPlot(dasPlot1);
        BoxZoomMouseModule boxmm = (BoxZoomMouseModule)dasPlot1.getDasMouseInputAdapter().getModuleByLabel("Box Zoom");
        dasPlot1.getDasMouseInputAdapter().setPrimaryModule((MouseModule)boxmm);
        MouseModuleType m = this.dom.getOptions().getMouseModule();
        MouseModule mm = null;
        if (null != m) {
            switch (m) {
                case boxZoom: {
                    break;
                }
                case crosshairDigitizer: {
                    mm = dasPlot1.getDasMouseInputAdapter().getModuleByLabel("Crosshair Digitizer");
                    break;
                }
                case zoomX: {
                    mm = dasPlot1.getDasMouseInputAdapter().getModuleByLabel("Zoom X");
                    break;
                }
            }
        }
        if (mm != null) {
            dasPlot1.getDasMouseInputAdapter().setPrimaryModule(mm);
        }
        MyFeedback feedback = new MyFeedback();
        dasPlot1.getDasMouseInputAdapter().setFeedback((DasMouseInputAdapter.Feedback)feedback);
        dasCanvas.add((DasCanvasComponent)colorbar, dasPlot1.getRow(), DasColorBar.getColorBarColumn((DasColumn)dasPlot1.getColumn()));
        ZoomPanMouseModule zoomPan = new ZoomPanMouseModule((DasCanvasComponent)dasPlot1, dasPlot1.getXAxis(), dasPlot1.getYAxis());
        dasPlot1.getDasMouseInputAdapter().setSecondaryModule((MouseModule)zoomPan);
        ZoomPanMouseModule zoomPanX = new ZoomPanMouseModule((DasCanvasComponent)dasPlot1.getXAxis(), dasPlot1.getXAxis(), null);
        dasPlot1.getXAxis().getDasMouseInputAdapter().setSecondaryModule((MouseModule)zoomPanX);
        dasPlot1.getXAxis().getDasMouseInputAdapter().setFeedback((DasMouseInputAdapter.Feedback)feedback);
        ZoomPanMouseModule zoomPanY = new ZoomPanMouseModule((DasCanvasComponent)dasPlot1.getYAxis(), null, dasPlot1.getYAxis());
        dasPlot1.getYAxis().getDasMouseInputAdapter().setSecondaryModule((MouseModule)zoomPanY);
        dasPlot1.getYAxis().getDasMouseInputAdapter().setFeedback((DasMouseInputAdapter.Feedback)feedback);
        ZoomPanMouseModule zoomPanZ = new ZoomPanMouseModule((DasCanvasComponent)colorbar, null, (DasAxis)colorbar);
        colorbar.getDasMouseInputAdapter().setSecondaryModule((MouseModule)zoomPanZ);
        colorbar.getDasMouseInputAdapter().setFeedback((DasMouseInputAdapter.Feedback)feedback);
        dasCanvas.revalidate();
        dasCanvas.repaint();
        ApplicationController ac = application.controller;
        ac.layoutListener.listenTo(dasPlot1);
        ac.layoutListener.listenTo((DasAxis)colorbar);
        new AxisController(application, this.plot, this.plot.getXaxis(), xaxis);
        new AxisController(application, this.plot, this.plot.getYaxis(), yaxis);
        new AxisController(application, this.plot, this.plot.getZaxis(), (DasAxis)colorbar);
        this.bindTo(dasPlot1);
        dasPlot1.addFocusListener((FocusListener)ac.focusAdapter);
        dasPlot1.getXAxis().addFocusListener((FocusListener)ac.focusAdapter);
        dasPlot1.getYAxis().addFocusListener((FocusListener)ac.focusAdapter);
        dasPlot1.addPropertyChangeListener("focusRenderer", ac.rendererFocusListener);
        ac.bind(this.plot, "isotropic", dasPlot1, "isotropic");
        ac.bind(this.plot, "displayTitle", dasPlot1, "displayTitle");
        ac.bind(this.plot, "displayLegend", dasPlot1, "displayLegend");
        ac.bind(this.plot, "fontSize", dasPlot1, "fontSize");
        ac.bind(this.plot, "legendFontSize", dasPlot1, "legendFontSize");
        ac.bind(application.getOptions(), "logMessageTimeoutSec", dasPlot1, "logTimeoutSec");
        ac.bind(application.getOptions(), "drawGrid", dasPlot1, "drawGrid");
        ac.bind(application.getOptions(), "drawMinorGrid", dasPlot1, "drawMinorGrid");
        ac.bind(application.getOptions(), "flipColorbarLabel", this.plot.getZaxis().getController().dasAxis, "flipLabel");
        ac.bind(application.getOptions(), "flipColorbarLabel", this.plot.getYaxis().getController().dasAxis, "flipLabel");
        ac.bind(application.getOptions(), "ticklen", dasPlot1.getXAxis(), "tickLength");
        ac.bind(application.getOptions(), "ticklen", dasPlot1.getYAxis(), "tickLength");
        ac.bind(application.getOptions(), "ticklen", colorbar, "tickLength");
        ac.bind(application.getOptions(), "oppositeAxisVisible", dasPlot1.getXAxis(), "oppositeAxisVisible");
        ac.bind(application.getOptions(), "oppositeAxisVisible", dasPlot1.getYAxis(), "oppositeAxisVisible");
        ac.bind(application.getOptions(), "lineThickness", dasPlot1.getXAxis(), "lineThickness");
        ac.bind(application.getOptions(), "lineThickness", dasPlot1.getYAxis(), "lineThickness");
        ac.bind(application.getOptions(), "lineThickness", colorbar, "lineThickness");
        ac.bind(application.getOptions(), "lineThickness", dasPlot1, "lineThickness");
        ac.bind(application.getOptions(), "multiLineTextAlignment", dasPlot1, "multiLineTextAlignment");
        ac.bind(application.getOptions(), "printingLogLevel", dasPlot1, "printingLogLevel");
        ac.bind(application.getOptions(), "displayLogLevel", dasPlot1, "logLevel");
        ac.bind(this.plot, "legendPosition", dasPlot1, "legendPosition");
        ac.bind(this.plot, "displayLegend", dasPlot1, "displayLegend");
        ac.bind(application.getOptions(), "overRendering", dasPlot1, "overSize");
        ac.bind(this.plot, "visible", dasPlot1, "plotVisible");
        ac.bind(this.plot, "colortable", colorbar, "type");
        dasPlot1.addPropertyChangeListener(this.listener);
        dasPlot1.getXAxis().addPropertyChangeListener(this.listener);
        dasPlot1.getYAxis().addPropertyChangeListener(this.listener);
        if (this.plot.getTicksURI().length() > 0) {
            logger.fine("setLabel(%{RANGE})");
            String dasAddress = "class:org.autoplot.tca.UriTcaSource:" + this.plot.getTicksURI();
            dasPlot1.getXAxis().setDataPath(dasAddress);
            dasPlot1.getXAxis().setDrawTca(true);
            if (this.plot.getXaxis().getLabel().contains("%{RANGE_NOORBIT}")) {
                logger.info("wait, someone already set this to RANGE_NOORBIT");
            } else if (this.plot.getXaxis().getLabel().equals(" ")) {
                logger.info("wait, someone already set this to a single space");
            } else {
                this.plot.getXaxis().setLabel("%{RANGE}");
            }
        }
        this.dasPlot = dasPlot1;
        this.dasColorBar = colorbar;
        this.dasPlot.setEnableRenderPropertiesAction(false);
        application.controller.maybeAddContextMenus(this);
        boolean headless = "true".equals(System.getProperty("java.awt.headless"));
        if (!headless && canvas.controller.getDropTargetListener() != null) {
            DropTarget dropTarget = new DropTarget();
            dropTarget.setComponent((Component)this.dasPlot);
            try {
                dropTarget.addDropTargetListener(canvas.controller.getDropTargetListener());
            }
            catch (TooManyListenersException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
            this.dasPlot.setDropTarget(dropTarget);
        }
        this.updateAxisFormatter(dasPlot1.getXAxis());
    }

    private Axis getDomAxis(DasAxis axis) {
        if (this.plot.xaxis.controller == null) {
            return null;
        }
        Axis domAxis = this.plot.xaxis.controller.dasAxis == axis ? this.plot.xaxis : (this.plot.yaxis.controller.dasAxis == axis ? this.plot.yaxis : (this.plot.zaxis.controller.dasAxis == axis ? this.plot.zaxis : null));
        return domAxis;
    }

    private void updateAxisFormatter(DasAxis axis) {
        logger.fine("updateAxisFormatter()");
        if (!(!UnitsUtil.isTimeLocation((Units)axis.getUnits()) || axis.getLabel().contains("%{RANGE") || axis.getFormat().trim().length() != 0 || axis.isDrawTca() && axis.getTickLines() > 1)) {
            axis.setUserDatumFormatter((DatumFormatter)new DateTimeDatumFormatter(this.dom.getController().getApplication().getOptions().isDayOfYear() ? 1 : 0));
        } else {
            TickVDescriptor.setDayOfYear((boolean)this.dom.getController().getApplication().getOptions().isDayOfYear());
            axis.setTickV(null);
            axis.setUserDatumFormatter(null);
        }
    }

    public DasColorBar getDasColorBar() {
        return this.dasColorBar;
    }

    public DasPlot getDasPlot() {
        return this.dasPlot;
    }

    private static void logCheck(Axis a) {
        if (a.isLog() && a.getRange().min().doubleValue(a.getRange().getUnits()) <= 0.0) {
            a.setLog(false);
        }
    }

    private Axis resolveSettings(Axis a1, Axis a2) {
        if (!a1.isAutoRange() && a2.isAutoRange()) {
            logger.log(Level.FINER, "resolveSettings axis a1 ({0}) is not autorange", new Object[]{a1.range.getUnits()});
            return a2;
        }
        if (!a2.isAutoRange() && a1.isAutoRange()) {
            logger.log(Level.FINER, "resolveSettings axis a2 ({0}) is not autorange", new Object[]{a2.range.getUnits()});
            return a1;
        }
        Axis result = new Axis();
        result.range = DatumRangeUtil.union((DatumRange)a1.range, (DatumRange)a2.range);
        logger.log(Level.FINER, "resolveSettings range {0} {1} -> {2}", new Object[]{a1.range, a2.range, result.range});
        result.log = a1.log == a2.log ? a1.log : result.range.min().doubleValue(result.range.getUnits()) > 0.0;
        result.autoRange = a1.autoRange && a2.isAutoRange();
        logger.log(Level.FINER, "resolveSettings range {0} {1} -> {2}", new Object[]{a1.range, a2.range, result.range});
        return result;
    }

    private Axis reluctantRanging(Axis axis, Axis newSettings) {
        try {
            if (DatumRangeUtil.rescale((DatumRange)axis.getRange(), (double)-1.0, (double)2.0).intersects(newSettings.getRange())) {
                double d1 = DatumRangeUtil.normalize((DatumRange)axis.getRange(), (Datum)newSettings.getRange().min(), (boolean)axis.isLog());
                double d2 = DatumRangeUtil.normalize((DatumRange)axis.getRange(), (Datum)newSettings.getRange().max(), (boolean)axis.isLog());
                if (Math.abs(d2 - d1) > 0.1) {
                    return axis;
                }
                return newSettings;
            }
            return newSettings;
        }
        catch (InconvertibleUnitsException ex) {
            return newSettings;
        }
    }

    public static void doHints(Axis axis, String hintsString) {
        AxisController ac;
        LinkedHashMap hints = URISplit.parseParams((String)hintsString);
        DatumRange range = axis.getRange();
        boolean log = axis.isLog();
        boolean includeZero = "T".equals(hints.get("includeZero"));
        Datum minValue = null;
        String s = (String)hints.get("min");
        if (s != null) {
            try {
                minValue = axis.getRange().getUnits().parse(s);
                if (axis.isLog() && minValue.value() <= 0.0) {
                    minValue = null;
                }
            }
            catch (ParseException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
        Datum maxValue = null;
        String s2 = (String)hints.get("max");
        if (s2 != null) {
            try {
                maxValue = axis.getRange().getUnits().parse(s2);
                if (axis.isLog() && maxValue.value() <= 0.0) {
                    maxValue = null;
                }
            }
            catch (ParseException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
        String width = (String)hints.get("width");
        String widths = (String)hints.get("widths");
        String center = (String)hints.get("center");
        String logHint = (String)hints.get("log");
        String extend = (String)hints.get("extend");
        if (logHint != null && UnitsUtil.isRatioMeasurement((Units)axis.getRange().getUnits())) {
            if (logHint.equals("T") && range.min().value() <= 0.0) {
                if (range.max().value() > 0.0) {
                    double m = range.max().value();
                    range = new DatumRange(m / 1000.0, m, range.getUnits());
                } else {
                    range = new DatumRange(1.0, 1000.0, range.getUnits());
                }
            }
            log = logHint.equals("T");
        }
        if (width != null) {
            Units u = range.getUnits().getOffsetUnits();
            Datum currentCenter = null;
            if (center != null) {
                try {
                    currentCenter = u.parse(center);
                }
                catch (ParseException ex) {
                    logger.log(Level.WARNING, null, ex);
                }
            }
            if (currentCenter == null) {
                currentCenter = log ? DatumRangeUtil.rescaleLog((DatumRange)range, (double)0.5, (double)0.5).min() : DatumRangeUtil.rescale((DatumRange)range, (double)0.5, (double)0.5).min();
            }
            try {
                Datum w;
                if (log) {
                    w = Units.log10Ratio.parse(width);
                    w = w.divide(2.0);
                    range = new DatumRange(currentCenter.divide(Math.pow(10.0, w.value())), currentCenter.multiply(Math.pow(10.0, w.value())));
                } else {
                    w = u.parse(width);
                    w = w.divide(2.0);
                    range = new DatumRange(currentCenter.subtract(w), currentCenter.add(w));
                }
            }
            catch (ParseException | InconvertibleUnitsException ex) {
                logger.log(Level.WARNING, null, ex);
            }
        }
        if (widths != null) {
            String[] wss = widths.split("\\,");
            Datum limit = log ? Units.log10Ratio.createDatum(Math.log10(range.max().divide(range.min()).value())) : range.width();
            Units u = range.getUnits().getOffsetUnits();
            for (String ws : wss) {
                try {
                    Datum w;
                    if (log) {
                        w = Units.log10Ratio.parse(ws);
                        if (!w.gt(limit) && !ws.equals(wss[wss.length - 1])) continue;
                        w = w.divide(2.0);
                        Datum currentCenter = DatumRangeUtil.rescaleLog((DatumRange)range, (double)0.5, (double)0.5).min();
                        range = new DatumRange(currentCenter.divide(Math.pow(10.0, w.value())), currentCenter.multiply(Math.pow(10.0, w.value())));
                        break;
                    }
                    w = u.parse(ws);
                    if (!w.gt(limit) && !ws.equals(wss[wss.length - 1])) continue;
                    w = w.divide(2.0);
                    Datum currentCenter = DatumRangeUtil.rescale((DatumRange)range, (double)0.5, (double)0.5).min();
                    range = new DatumRange(currentCenter.subtract(w), currentCenter.add(w));
                    break;
                }
                catch (ParseException | InconvertibleUnitsException ex) {
                    logger.log(Level.WARNING, null, ex);
                }
            }
        }
        if (includeZero && UnitsUtil.isRatioMeasurement((Units)range.getUnits())) {
            Datum z = range.getUnits().createDatum(0);
            if (widths == null && width == null) {
                range = DatumRangeUtil.union((DatumRange)range, (Datum)z);
            } else if (range.min().value() > 0.0) {
                double n = DatumRangeUtil.normalize((DatumRange)range, (Datum)z);
                range = DatumRangeUtil.rescale((DatumRange)range, (double)n, (double)(n + 1.0));
            } else if (range.max().value() < 0.0) {
                double n = DatumRangeUtil.normalize((DatumRange)range, (Datum)z);
                range = DatumRangeUtil.rescale((DatumRange)range, (double)(n - 1.0), (double)n);
            }
        }
        if (minValue != null && UnitsUtil.isRatioMeasurement((Units)range.getUnits())) {
            if (widths == null && width == null) {
                if (range.max().gt(minValue)) {
                    range = DatumRange.newRange((Datum)minValue, (Datum)range.max());
                }
            } else {
                Datum w = range.width();
                range = DatumRange.newRange((Datum)minValue, (Datum)minValue.add(w));
            }
        }
        if (maxValue != null && UnitsUtil.isRatioMeasurement((Units)range.getUnits())) {
            if (widths == null && width == null) {
                if (range.min().lt(maxValue)) {
                    range = DatumRange.newRange((Datum)range.min(), (Datum)maxValue);
                }
            } else {
                Datum w = range.width();
                range = DatumRange.newRange((Datum)maxValue.subtract(w), (Datum)maxValue);
            }
        }
        if (center != null) {
            Units u = range.getUnits();
            try {
                if (log) {
                    double w2;
                    Datum currentCenter = u.parse(center);
                    double w1 = Math.abs(Math.log10(range.min().divide(currentCenter).value()));
                    double w = w1 >= (w2 = Math.abs(Math.log10(range.max().divide(currentCenter).value()))) ? w1 : w2;
                    range = new DatumRange(currentCenter.divide(Math.pow(10.0, w)), currentCenter.multiply(Math.pow(10.0, w)));
                } else {
                    Datum w2;
                    Datum currentCenter = u.parse(center);
                    Datum w1 = range.min().subtract(currentCenter).abs();
                    Datum w = w1.ge(w2 = range.max().subtract(currentCenter).abs()) ? w1 : w2;
                    range = new DatumRange(currentCenter.subtract(w), currentCenter.add(w));
                }
            }
            catch (ParseException | InconvertibleUnitsException ex) {
                logger.log(Level.WARNING, null, ex);
            }
        }
        if (extend != null) {
            double dextendmax;
            double dextendmin;
            if (extend.contains(",")) {
                String[] ss = extend.split(",");
                dextendmin = Double.parseDouble(ss[0]) / 100.0;
                dextendmax = Double.parseDouble(ss[1]) / 100.0;
            } else {
                dextendmax = dextendmin = Double.parseDouble(extend) / 100.0 / 2.0;
            }
            range = log ? DatumRangeUtil.rescaleLog((DatumRange)range, (double)(0.0 - dextendmin), (double)(1.0 + dextendmax)) : DatumRangeUtil.rescale((DatumRange)range, (double)(0.0 - dextendmin), (double)(1.0 + dextendmax));
        }
        if ((ac = axis.getController()) != null) {
            ac.setRangeAutomatically(range, log);
        } else {
            axis.setRange(range);
            axis.setLog(log);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void resetZoom(boolean x, boolean y, boolean z) {
        logger.entering("PlotController", "resetZoom", new Object[]{x, y, z});
        List<PlotElement> elements = this.dom.controller.getPlotElementsFor(this.plot);
        if (elements.isEmpty()) {
            return;
        }
        Plot newSettings = null;
        boolean haveTsb = false;
        boolean alsoBindings = false;
        if (alsoBindings) {
            Plot other;
            Axis oa;
            List<BindingModel> plots = DomUtil.findBindings(this.dom, this.plot.getXaxis(), "range");
            for (BindingModel bindingModel : plots) {
                if (bindingModel.getDstId().equals(this.plot.getXaxis().getId())) {
                    oa = (Axis)DomUtil.getElementById(this.dom, bindingModel.getSrcId());
                    other = DomUtil.getPlotForAxis(this.dom, oa);
                } else {
                    oa = (Axis)DomUtil.getElementById(this.dom, bindingModel.getDstId());
                    other = DomUtil.getPlotForAxis(this.dom, oa);
                }
                elements.addAll(DomUtil.getPlotElementsFor(this.dom, other));
            }
            plots = DomUtil.findBindings(this.dom, this.plot.getYaxis(), "range");
            for (BindingModel bindingModel : plots) {
                if (bindingModel.getDstId().equals(this.plot.getYaxis().getId())) {
                    oa = (Axis)DomUtil.getElementById(this.dom, bindingModel.getSrcId());
                    other = DomUtil.getPlotForAxis(this.dom, oa);
                } else {
                    oa = (Axis)DomUtil.getElementById(this.dom, bindingModel.getDstId());
                    other = DomUtil.getPlotForAxis(this.dom, oa);
                }
                elements.addAll(DomUtil.getPlotElementsFor(this.dom, other));
            }
            plots = DomUtil.findBindings(this.dom, this.plot.getZaxis(), "range");
            for (BindingModel bindingModel : plots) {
                if (bindingModel.getDstId().equals(this.plot.getZaxis().getId())) {
                    oa = (Axis)DomUtil.getElementById(this.dom, bindingModel.getSrcId());
                    other = DomUtil.getPlotForAxis(this.dom, oa);
                } else {
                    oa = (Axis)DomUtil.getElementById(this.dom, bindingModel.getDstId());
                    other = DomUtil.getPlotForAxis(this.dom, oa);
                }
                elements.addAll(DomUtil.getPlotElementsFor(this.dom, other));
            }
        }
        boolean warnedAboutUnits = false;
        for (PlotElement plotElement : elements) {
            DataSourceFilter dsf;
            block40: {
                Plot plot1 = plotElement.getPlotDefaults();
                if (newSettings == null) {
                    newSettings = (Plot)plot1.copy();
                } else {
                    block39: {
                        block38: {
                            try {
                                newSettings.xaxis = this.resolveSettings(newSettings.xaxis, plot1.getXaxis());
                            }
                            catch (InconvertibleUnitsException ex) {
                                if (warnedAboutUnits) break block38;
                                logger.log(Level.FINE, "plot elements on the same xaxis have inconsistent units: {0} {1}", new Object[]{newSettings.xaxis.range.getUnits().toString(), plot1.getXaxis().getRange().getUnits().toString()});
                                warnedAboutUnits = true;
                            }
                        }
                        try {
                            newSettings.yaxis = this.resolveSettings(newSettings.yaxis, plot1.getYaxis());
                        }
                        catch (InconvertibleUnitsException ex) {
                            if (warnedAboutUnits) break block39;
                            logger.log(Level.FINE, "plot elements on the same yaxis have inconsistent units: {0} {1}", new Object[]{newSettings.yaxis.range.getUnits().toString(), plot1.getYaxis().getRange().getUnits().toString()});
                            warnedAboutUnits = true;
                        }
                    }
                    try {
                        newSettings.zaxis = this.resolveSettings(newSettings.zaxis, plot1.getZaxis());
                    }
                    catch (InconvertibleUnitsException ex) {
                        if (warnedAboutUnits) break block40;
                        logger.log(Level.FINE, "plot elements on the same zaxis have inconsistent units: {0} {1}", new Object[]{newSettings.zaxis.range.getUnits().toString(), plot1.getZaxis().getRange().getUnits().toString()});
                        warnedAboutUnits = true;
                    }
                }
            }
            if ((dsf = this.dom.controller.getDataSourceFilterFor(plotElement)) == null || dsf.getController() == null || dsf.getController().getTsb() == null) continue;
            haveTsb = true;
        }
        DatumRange range = newSettings.getYaxis().getRange();
        for (PlotElement p : elements) {
            Plot plot1 = p.getPlotDefaults();
            if (range.getUnits().isConvertibleTo(plot1.getYaxis().getRange().getUnits())) {
                double dmax;
                double dmin;
                if (plot1.getYaxis().isLog()) {
                    dmin = DatumRangeUtil.normalizeLog((DatumRange)range, (Datum)plot1.getYaxis().getRange().min());
                    dmax = DatumRangeUtil.normalizeLog((DatumRange)range, (Datum)plot1.getYaxis().getRange().max());
                    if (!(dmax - dmin < 0.1)) continue;
                    if (dmin == 0.0) {
                        range = DatumRangeUtil.rescaleLog((DatumRange)range, (double)-0.05, (double)1.0);
                        continue;
                    }
                    if (dmax != 1.0) continue;
                    range = DatumRangeUtil.rescaleLog((DatumRange)range, (double)0.0, (double)1.05);
                    continue;
                }
                dmin = DatumRangeUtil.normalize((DatumRange)range, (Datum)plot1.getYaxis().getRange().min());
                dmax = DatumRangeUtil.normalize((DatumRange)range, (Datum)plot1.getYaxis().getRange().max());
                if (!(dmax - dmin < 0.1)) continue;
                if (dmin == 0.0) {
                    range = DatumRangeUtil.rescale((DatumRange)range, (double)-0.05, (double)1.0);
                    continue;
                }
                if (dmax != 1.0) continue;
                range = DatumRangeUtil.rescale((DatumRange)range, (double)0.0, (double)1.05);
                continue;
            }
            logger.fine("extra check for 10% margin cannot be done");
        }
        if (!range.equals((Object)newSettings.getYaxis().getRange())) {
            newSettings.getYaxis().setRange(range);
        }
        if (newSettings == null) {
            this.plot.getXaxis().setAutoRange(true);
            this.plot.getYaxis().setAutoRange(true);
            this.plot.getZaxis().setAutoRange(true);
            logger.exiting("PlotController", "resetZoom");
            return;
        }
        if (x) {
            void var10_21;
            PlotController.logCheck(newSettings.getXaxis());
            Axis axis = newSettings.getXaxis();
            if (this.plot.getXaxis().getAutoRangeHints().length() > 0) {
                PlotController.doHints(axis, this.plot.getXaxis().getAutoRangeHints());
            }
            if (this.dom.options.getAutorangeType().equals("reluctant")) {
                Axis axis2 = this.reluctantRanging(this.plot.getXaxis(), axis);
            }
            this.plot.getXaxis().setLog(var10_21.isLog());
            this.plot.getXaxis().setRange(var10_21.getRange());
            this.plot.getXaxis().setAutoRange(true);
            if (haveTsb) {
                this.plot.getXaxis().getController().dasAxis.setScanRange(null);
            } else {
                this.plot.getXaxis().getController().dasAxis.setScanRange(this.plot.getXaxis().getRange());
            }
        }
        if (y) {
            void var10_25;
            PlotController.logCheck(newSettings.getYaxis());
            Axis axis = newSettings.getYaxis();
            if (this.plot.getYaxis().getAutoRangeHints().length() > 0) {
                PlotController.doHints(axis, this.plot.getYaxis().getAutoRangeHints());
            }
            if (this.dom.options.getAutorangeType().equals("reluctant")) {
                Axis axis3 = this.reluctantRanging(this.plot.getYaxis(), axis);
            }
            this.plot.getYaxis().setLog(var10_25.isLog());
            this.plot.getYaxis().setRange(var10_25.getRange());
            this.plot.getYaxis().setAutoRange(true);
            this.plot.getYaxis().getController().dasAxis.setScanRange(var10_25.getRange());
        }
        if (z) {
            void var10_29;
            PlotController.logCheck(newSettings.getZaxis());
            Axis axis = newSettings.getZaxis();
            if (this.plot.getZaxis().getAutoRangeHints().length() > 0) {
                PlotController.doHints(axis, this.plot.getZaxis().getAutoRangeHints());
            }
            if (this.dom.options.getAutorangeType().equals("reluctant")) {
                Axis axis4 = this.reluctantRanging(this.plot.getZaxis(), axis);
            }
            this.plot.getZaxis().setLog(var10_29.isLog());
            this.plot.getZaxis().setRange(var10_29.getRange());
            this.plot.getZaxis().setAutoRange(true);
            this.plot.getZaxis().getController().dasAxis.setScanRange(var10_29.getRange());
        }
        logger.log(Level.FINER, "xrange: {0}", this.plot.getXaxis().getRange());
        logger.log(Level.FINER, "yrange: {0}", this.plot.getYaxis().getRange());
        logger.log(Level.FINER, "zrange: {0}", this.plot.getZaxis().getRange());
        logger.exiting("PlotController", "resetZoom");
    }

    public PlotElement getPlotElement() {
        return this.plotElement;
    }

    private void checkRenderType() {
        if (this.dom.getController().isValueAdjusting()) {
            return;
        }
        boolean needsColorbar = false;
        for (PlotElement p : this.dom.getController().getPlotElementsFor(this.plot)) {
            if (!RenderTypeUtil.needsColorbar(p.getRenderType())) continue;
            needsColorbar = true;
        }
        this.plot.getZaxis().setVisible(needsColorbar);
    }

    void addPlotElement(PlotElement p) {
        this.addPlotElement(p, true);
    }

    private List<Integer> indecesOfPlotElements() {
        ArrayList<Integer> indeces = new ArrayList<Integer>(this.dom.plotElements.size());
        for (int i = 0; i < this.dom.plotElements.size(); ++i) {
            if (!this.dom.getPlotElements(i).getPlotId().equals(this.plot.getId())) continue;
            indeces.add(i);
        }
        return indeces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveToStackBottom(PlotElement p) {
        ChangesSupport.DomLock lock = this.dom.getController().mutatorLock();
        lock.lock("Move to Stack Bottom");
        try {
            int ploc;
            int bottom;
            if (!p.getPlotId().equals(this.plot.getId())) {
                throw new IllegalArgumentException("this is not my plot");
            }
            PlotElement[] newPes = this.dom.getPlotElements();
            for (bottom = 0; bottom < newPes.length && !newPes[bottom].getPlotId().equals(p.getPlotId()); ++bottom) {
            }
            for (ploc = 0; ploc < newPes.length && newPes[ploc] != p; ++ploc) {
            }
            if (ploc > bottom) {
                for (int i = ploc; i > bottom; --i) {
                    newPes[i] = newPes[i - 1];
                }
                newPes[bottom] = p;
            }
            this.dom.setPlotElements(newPes);
        }
        finally {
            lock.unlock();
        }
    }

    public void toBottom(PlotElement p) {
        this.moveToStackBottom(p);
        DasPlot pp = p.getController().getDasPlot();
        Renderer r = p.getController().getRenderer();
        pp.removeRenderer(r);
        pp.addRenderer(0, r);
    }

    public void toTop(PlotElement p) {
        this.moveToStackTop(p);
        DasPlot pp = p.getController().getDasPlot();
        Renderer r = p.getController().getRenderer();
        pp.removeRenderer(r);
        pp.addRenderer(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveToJustAbove(PlotElement reference, PlotElement p) {
        if (reference == p) {
            throw new IllegalArgumentException("reference and p are the same plot element");
        }
        if (!reference.getPlotId().equals(p.getPlotId())) {
            throw new IllegalArgumentException("reference and p must be in the same plot");
        }
        ChangesSupport.DomLock lock = this.dom.getController().mutatorLock();
        lock.lock("Move to Just Above");
        try {
            if (!p.getPlotId().equals(this.plot.getId())) {
                throw new IllegalArgumentException("this is not my plot");
            }
            Application dom2 = (Application)this.dom.copy();
            DomUtil.moveToJustAbove(dom2, reference.getId(), p.getId());
            this.dom.syncTo(dom2);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveToJustBelow(PlotElement reference, PlotElement p) {
        if (reference == p) {
            throw new IllegalArgumentException("reference and p are the same plot element");
        }
        if (!reference.getPlotId().equals(p.getPlotId())) {
            throw new IllegalArgumentException("reference and p must be in the same plot");
        }
        ChangesSupport.DomLock lock = this.dom.getController().mutatorLock();
        lock.lock("Move to Just Below");
        try {
            if (!p.getPlotId().equals(this.plot.getId())) {
                throw new IllegalArgumentException("this is not my plot");
            }
            Application dom2 = (Application)this.dom.copy();
            DomUtil.moveToJustBelow(dom2, reference.getId(), p.getId());
            this.dom.syncTo(dom2);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void moveToStackTop(PlotElement p) {
        ChangesSupport.DomLock lock = this.dom.getController().mutatorLock();
        lock.lock("Move to Stack Top");
        try {
            int ploc;
            int top;
            if (!p.getPlotId().equals(this.plot.getId())) {
                throw new IllegalArgumentException("this is not my plot");
            }
            PlotElement[] newPes = this.dom.getPlotElements();
            for (top = newPes.length - 1; top >= 0 && !newPes[top].getPlotId().equals(p.getPlotId()); --top) {
            }
            for (ploc = 0; ploc < newPes.length && newPes[ploc] != p; ++ploc) {
            }
            if (ploc < top) {
                for (int i = ploc; i < top; ++i) {
                    newPes[i] = newPes[i + 1];
                }
                newPes[top] = p;
            }
            this.dom.setPlotElements(newPes);
        }
        finally {
            lock.unlock();
        }
    }

    void bindPEToColorbar(PlotElement pe) {
        if (this.plot == null) {
            throw new NullPointerException("plotController.plot is null");
        }
        if (pe.style == null) {
            throw new NullPointerException("Style pe.style is null");
        }
        this.dom.controller.bind(this.plot, "colortable", pe.style, "colortable");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPlotElement(PlotElement p, boolean reset) {
        ChangesSupport.DomLock lock = this.changesSupport.mutatorLock();
        lock.lock("addPlotElement");
        try {
            boolean toTop;
            if (p == null) {
                throw new NullPointerException("PlotElement p is null");
            }
            Renderer rr = p.controller.getRenderer();
            if (rr instanceof SpectrogramRenderer) {
                ((SpectrogramRenderer)rr).setColorBar(this.getDasColorBar());
            } else if (rr instanceof SeriesRenderer) {
                ((SeriesRenderer)rr).setColorBar(this.getDasColorBar());
            }
            this.bindPEToColorbar(p);
            boolean bl = toTop = rr != null && !(rr instanceof SpectrogramRenderer);
            if (rr != null) {
                if (!toTop) {
                    this.dasPlot.addRenderer(0, rr);
                } else {
                    this.dasPlot.addRenderer(rr);
                }
            }
            RenderType rt = p.getRenderType();
            p.plotId = this.plot.getId();
            if (reset) {
                p.controller.doResetRenderType(rt);
            }
            if (!this.dom.controller.isValueAdjusting()) {
                this.doPlotElementDefaultsChange(p);
            } else {
                boolean isFirst = false;
                for (PlotElement pete : this.dom.getPlotElements()) {
                    if (!pete.plotId.equals(this.plot.id)) continue;
                    if (pete != p) break;
                    isFirst = true;
                    break;
                }
                if (this.plotElement != null && isFirst) {
                    this.plotElement.getController().removePropertyChangeListener("dataSet", this.plotElementDataSetListener);
                }
                if (isFirst) {
                    this.plotElement = p;
                    p.getController().addPropertyChangeListener("dataSet", this.plotElementDataSetListener);
                }
            }
            if (!this.pdListen.contains(p)) {
                p.addPropertyChangeListener("plotDefaults", this.plotDefaultsListener);
                p.addPropertyChangeListener("renderType", this.renderTypeListener);
                this.pdListen.add(p);
            }
            p.setPlotId(this.plot.getId());
            this.checkRenderType();
            if (rr != null && toTop) {
                this.moveToStackTop(p);
            }
        }
        finally {
            lock.unlock();
        }
    }

    public QDataSet getActiveDataSet() {
        return this.activeDataSet;
    }

    public void setActiveDataSet(QDataSet activeDataSet) {
        QDataSet oldActiveDataSet = this.activeDataSet;
        this.activeDataSet = activeDataSet;
        this.propertyChangeSupport.firePropertyChange(PROP_ACTIVEDATASET, oldActiveDataSet, activeDataSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Plot contextOverview() {
        Plot that;
        ChangesSupport.DomLock lock = this.changesSupport.mutatorLock();
        lock.lock("Context Overview");
        try {
            double nmax;
            double nmin;
            Plot domPlot = this.plot;
            ApplicationController controller = this.dom.getController();
            that = controller.copyPlotAndPlotElements(domPlot, null, false, false);
            that.setTitle("");
            controller.bind(domPlot.getYaxis(), "log", that.getYaxis(), "log");
            controller.bind(domPlot.getZaxis(), "range", that.getZaxis(), "range");
            controller.bind(domPlot.getZaxis(), "log", that.getZaxis(), "log");
            controller.bind(domPlot.getZaxis(), "label", that.getZaxis(), "label");
            controller.addConnector(domPlot, that);
            controller.setPlot(that);
            AutoplotUtil.resetZoomY(this.dom);
            if (domPlot.getYaxis().isLog()) {
                nmin = DatumRangeUtil.normalizeLog((DatumRange)that.getYaxis().getRange(), (Datum)domPlot.getYaxis().getRange().min());
                nmax = DatumRangeUtil.normalizeLog((DatumRange)that.getYaxis().getRange(), (Datum)domPlot.getYaxis().getRange().max());
            } else {
                nmin = DatumRangeUtil.normalize((DatumRange)that.getYaxis().getRange(), (Datum)domPlot.getYaxis().getRange().min());
                nmax = DatumRangeUtil.normalize((DatumRange)that.getYaxis().getRange(), (Datum)domPlot.getYaxis().getRange().max());
            }
            if (nmax - nmin > 0.9) {
                that.getYaxis().setRange(domPlot.getYaxis().getRange());
            }
            AutoplotUtil.resetZoomX(this.dom);
        }
        finally {
            lock.unlock();
        }
        return that;
    }

    private void removeBindingsPEToColorbar(PlotElement pe) {
        this.dom.controller.unbind(pe.style, "colortable", this.plot, "colortable");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removePlotElement(PlotElement p) {
        ChangesSupport.DomLock lock = this.changesSupport.mutatorLock();
        lock.lock("removePlotElement");
        try {
            Renderer rr = p.controller.getRenderer();
            if (rr != null && this.dasPlot.containsRenderer(rr)) {
                this.dasPlot.removeRenderer(rr);
            }
            if (rr instanceof SpectrogramRenderer) {
                ((SpectrogramRenderer)rr).setColorBar(null);
            } else if (rr instanceof SeriesRenderer) {
                ((SeriesRenderer)rr).setColorBar(null);
            }
            this.doPlotElementDefaultsChange(null);
            p.removePropertyChangeListener("plotDefaults", this.plotDefaultsListener);
            p.removePropertyChangeListener("renderType", this.renderTypeListener);
            this.removeBindingsPEToColorbar(p);
            this.pdListen.remove(p);
            if (!p.getPlotId().equals("")) {
                p.setPlotId("");
            }
            this.checkRenderType();
        }
        finally {
            lock.unlock();
        }
    }

    private Plot getPlotDefaultsOneFamily(List<PlotElement> pes) {
        Plot result = null;
        if (pes.size() > 0) {
            result = pes.get(0).getPlotDefaults();
        }
        return result;
    }

    private void doPlotElementDefaultsChange(PlotElement pele) {
        List<PlotElement> pes;
        BindingModel existingBinding;
        List<BindingModel> bms;
        if (pele != null && this.isAutoBinding()) {
            this.doCheckBindings(this.plot, pele.getPlotDefaults());
        }
        if ((bms = this.dom.getController().findBindings(this.dom, "timeRange", null, "range")).contains(existingBinding = this.dom.getController().findBinding(this.dom, "timeRange", this.plot.xaxis, "range")) && bms.size() > 1) {
            this.plot.getXaxis().setAutoRange(false);
        }
        if (DomUtil.oneFamily(pes = this.dom.getController().getPlotElementsFor(this.plot))) {
            Plot defaults = this.getPlotDefaultsOneFamily(pes);
            PlotElement p = pes.get(0);
            if (!this.plot.controller.getApplication().getController().isValueAdjusting()) {
                if (!this.dom.getController().isBoundAxis(this.plot.getXaxis()) && !defaults.getXaxis().getRange().getUnits().isConvertibleTo(this.plot.getXaxis().getRange().getUnits())) {
                    this.plot.getXaxis().setAutoRange(true);
                }
                if (!this.dom.getController().isBoundAxis(this.plot.getYaxis()) && !defaults.getYaxis().getRange().getUnits().isConvertibleTo(this.plot.getYaxis().getRange().getUnits())) {
                    this.plot.getYaxis().setAutoRange(true);
                }
                if (!this.dom.getController().isBoundAxis(this.plot.getZaxis()) && !defaults.getZaxis().getRange().getUnits().isConvertibleTo(this.plot.getZaxis().getRange().getUnits())) {
                    this.plot.getZaxis().setAutoRange(true);
                }
            } else {
                logger.fine("value is adjusting, no reset autorange");
            }
            boolean isFirst = false;
            for (PlotElement pete : this.dom.getPlotElements()) {
                if (!pete.plotId.equals(this.plot.id)) continue;
                if (pete != p) break;
                isFirst = true;
                break;
            }
            if (this.plotElement != null && isFirst) {
                this.plotElement.getController().removePropertyChangeListener("dataSet", this.plotElementDataSetListener);
            }
            if (isFirst) {
                this.plotElement = p;
                this.plotElement.getController().addPropertyChangeListener("dataSet", this.plotElementDataSetListener);
            }
            if (defaults != null) {
                if (this.plot.isAutoLabel()) {
                    this.plot.getController().setTitleAutomatically(defaults.getTitle());
                }
                if (this.plot.getXaxis().isAutoLabel() && defaults.getXaxis().isAutoLabel()) {
                    this.plot.getXaxis().getController().setLabelAutomatically(defaults.getXaxis().getLabel());
                }
                if (this.plot.getYaxis().isAutoLabel() && defaults.getYaxis().isAutoLabel()) {
                    this.plot.getYaxis().getController().setLabelAutomatically(defaults.getYaxis().getLabel());
                }
                if (this.plot.getZaxis().isAutoLabel() && defaults.getZaxis().isAutoLabel()) {
                    this.plot.getZaxis().getController().setLabelAutomatically(defaults.getZaxis().getLabel());
                }
                if (this.plot.getXaxis().isAutoRange() && this.plot.getYaxis().isAutoRange()) {
                    this.plot.setIsotropic(defaults.isIsotropic());
                }
            } else {
                if (this.plot.isAutoLabel()) {
                    this.plot.getController().setTitleAutomatically(p.getPlotDefaults().getTitle());
                }
                if (this.plot.getXaxis().isAutoLabel()) {
                    this.plot.getXaxis().getController().setLabelAutomatically("");
                }
                if (this.plot.getYaxis().isAutoLabel()) {
                    this.plot.getYaxis().getController().setLabelAutomatically("");
                }
                if (this.plot.getZaxis().isAutoLabel()) {
                    this.plot.getZaxis().getController().setLabelAutomatically("");
                }
            }
        }
        if (this.dom.getOptions().isAutoranging()) {
            this.resetZoom(this.plot.getXaxis().isAutoRange() && pele != null && pele.getPlotDefaults().getXaxis().isAutoRange(), this.plot.getYaxis().isAutoRange(), this.plot.getZaxis().isAutoRange());
        }
    }

    protected void doPlotElementDefaultsUnitsChange(PlotElement e) {
        boolean auto;
        DatumRange dr;
        DatumRange elerange = e.getPlotDefaults().getXaxis().getRange();
        DatumRange range = this.plot.getXaxis().getRange();
        if (elerange.getUnits() != range.getUnits() && range.getUnits() == Units.dimensionless) {
            dr = UnitsUtil.isTimeLocation((Units)elerange.getUnits()) ? DatumRangeUtil.parseTimeRangeValid((String)"2010-01-01") : new DatumRange(range.min().doubleValue(Units.dimensionless), range.max().doubleValue(Units.dimensionless), elerange.getUnits());
            auto = this.plot.getXaxis().autoRange;
            this.plot.getXaxis().setRange(dr);
            this.plot.getXaxis().setAutoRange(auto);
        }
        elerange = e.getPlotDefaults().getYaxis().getRange();
        range = this.plot.getYaxis().getRange();
        if (!UnitsUtil.isTimeLocation((Units)elerange.getUnits()) && elerange.getUnits() != range.getUnits() && range.getUnits() == Units.dimensionless) {
            dr = UnitsUtil.isTimeLocation((Units)elerange.getUnits()) ? DatumRangeUtil.parseTimeRangeValid((String)"2010-01-01") : new DatumRange(range.min().doubleValue(Units.dimensionless), range.max().doubleValue(Units.dimensionless), elerange.getUnits());
            auto = this.plot.getYaxis().autoRange;
            this.plot.getYaxis().setRange(dr);
            this.plot.getYaxis().setAutoRange(auto);
        }
        elerange = e.getPlotDefaults().getZaxis().getRange();
        range = this.plot.getZaxis().getRange();
        if (!UnitsUtil.isTimeLocation((Units)elerange.getUnits()) && elerange.getUnits() != range.getUnits() && range.getUnits() == Units.dimensionless) {
            dr = UnitsUtil.isTimeLocation((Units)elerange.getUnits()) ? DatumRangeUtil.parseTimeRangeValid((String)"2010-01-01") : new DatumRange(range.min().doubleValue(Units.dimensionless), range.max().doubleValue(Units.dimensionless), elerange.getUnits());
            auto = this.plot.getZaxis().autoRange;
            this.plot.getZaxis().setRange(dr);
            this.plot.getZaxis().setAutoRange(auto);
        }
    }

    private boolean shouldBindX(Axis newSettingsXaxis) {
        boolean shouldBindX = false;
        DatumRange xrange = newSettingsXaxis.getRange();
        if (this.dom.timeRange.getUnits().isConvertibleTo(xrange.getUnits()) && UnitsUtil.isTimeLocation((Units)xrange.getUnits())) {
            if (this.dom.controller.isConnected(this.plot)) {
                logger.log(Level.FINER, "not binding because plot is connected: {0}", this.plot);
            } else if (this.dom.timeRange.intersects(xrange)) {
                try {
                    double reqOverlap = UnitsUtil.isTimeLocation((Units)this.dom.timeRange.getUnits()) ? 0.01 : 0.8;
                    DatumRange droverlap = DatumRangeUtil.sloppyIntersection((DatumRange)xrange, (DatumRange)this.dom.timeRange);
                    double overlap = droverlap.width().divide(this.dom.timeRange.width()).doubleValue(Units.dimensionless);
                    if (overlap > 1.0) {
                        overlap = 1.0 / overlap;
                    }
                    if (overlap > reqOverlap) {
                        shouldBindX = true;
                        logger.log(Level.FINER, "binding axis because there is significant overlap dom.timerange={0}", this.dom.timeRange.toString());
                        this.dom.getController().setStatus("binding axis because there is significant overlap");
                    }
                }
                catch (InconvertibleUnitsException ex) {
                    shouldBindX = false;
                }
                catch (IllegalArgumentException ex) {
                    shouldBindX = false;
                }
            }
        }
        return shouldBindX;
    }

    private void doCheckBindings(Plot plot, Plot newSettings) {
        List<BindingModel> b;
        logger.entering("PlotController", "doCheckBindings");
        boolean shouldBindX = false;
        boolean shouldSetAxisRange = false;
        List<BindingModel> bms = this.dom.getController().findBindings(this.dom, "timeRange", null, "range");
        BindingModel bm = this.dom.getController().findBinding(this.dom, "timeRange", plot.getXaxis(), "range");
        if (bm != null) {
            bms.remove(bm);
        }
        if (!plot.isAutoBinding()) {
            logger.exiting("PlotController", "doCheckBindings");
            return;
        }
        boolean needToAutorangeAfterAll = false;
        if (!plot.getXaxis().isAutoRange()) {
            boolean bl = shouldBindX = bm != null;
            if (bm != null && !newSettings.getXaxis().getRange().getUnits().isConvertibleTo(plot.getXaxis().getRange().getUnits())) {
                shouldBindX = false;
                logger.finer("remove timerange binding that would cause inconvertable units");
            }
            if (!shouldBindX) {
                shouldBindX = this.shouldBindX(newSettings.getXaxis());
            }
            boolean bl2 = needToAutorangeAfterAll = UnitsUtil.isTimeLocation((Units)plot.getXaxis().getRange().getUnits()) && !shouldBindX;
        }
        if (!newSettings.getXaxis().isLog() && (needToAutorangeAfterAll || plot.getXaxis().isAutoRange())) {
            if (bms.isEmpty() && UnitsUtil.isTimeLocation((Units)newSettings.getXaxis().getRange().getUnits())) {
                logger.finer("binding axis to timeRange because no one is using it");
                DatumRange tr = plot.getXaxis().getRange();
                if (UnitsUtil.isTimeLocation((Units)tr.getUnits())) {
                    this.dom.setTimeRange(tr);
                } else {
                    this.dom.setTimeRange(newSettings.getXaxis().getRange());
                }
                shouldSetAxisRange = true;
            }
            if (!plot.getXaxis().isAutoRange()) {
                if (needToAutorangeAfterAll && bm != null) {
                    this.dom.getController().removeBinding(bm);
                }
                plot.getXaxis().setAutoRange(true);
            }
            shouldBindX = this.shouldBindX(newSettings.getXaxis());
        }
        if (bm == null && shouldBindX) {
            logger.log(Level.FINER, "add binding: {0}", plot.getXaxis());
            plot.getXaxis().setLog(false);
            this.dom.getController().bind(this.dom, "timeRange", plot.getXaxis(), "range");
            b = this.dom.getController().findBinding(this.dom, "timeRange", plot, "context");
            if (b != null) {
                this.dom.getController().removeBinding((BindingModel)((Object)b));
            }
        } else if (bm != null && !shouldBindX) {
            logger.log(Level.FINER, "remove binding: {0}", bm);
            plot.setContext(this.dom.getTimeRange());
            this.dom.getController().removeBinding(bm);
        }
        if (needToAutorangeAfterAll) {
            plot.getXaxis().setAutoRange(true);
        }
        if (!shouldBindX) {
            b = this.dom.getController().findBindings(this.dom, "timeRange");
            if (b.isEmpty() && UnitsUtil.isTimeLocation((Units)plot.getContext().getUnits())) {
                DatumRange dr = plot.getContext();
                this.dom.setTimeRange(dr);
            }
            this.dom.getController().bind(this.dom, "timeRange", plot, "context");
        }
        plot.setAutoBinding(false);
        logger.exiting("PlotController", "doCheckBindings");
    }

    void deleteDasPeer() {
        final DasPlot p = this.getDasPlot();
        final DasColorBar cb = this.getDasColorBar();
        final DasCanvas c = p.getCanvas();
        p.getDasMouseInputAdapter().setFeedback(DasMouseInputAdapter.NULL_FEEDBACK);
        if (c != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    c.remove((Component)p);
                    c.remove((Component)cb);
                }
            });
        }
        p.getDasMouseInputAdapter().releaseAll();
    }

    private void bindTo(DasPlot p) {
        ApplicationController ac = this.dom.controller;
        this.titleConverter = new LabelConverter(this.dom, this.plot, this.plot.xaxis, null, null);
        this.titleConverter.setControlledNode(this.plot);
        ac.bind(this.plot, "title", p, "title", this.titleConverter);
        Converter plotContextConverter = new Converter(){

            public Object convertForward(Object s) {
                if (s == Application.DEFAULT_TIME_RANGE) {
                    return null;
                }
                return s;
            }

            public Object convertReverse(Object t) {
                if (t == null) {
                    return Application.DEFAULT_TIME_RANGE;
                }
                return t;
            }
        };
        this.plot.addPropertyChangeListener(this.plotListener);
        this.plot.xaxis.addPropertyChangeListener(this.plotListener);
        ac.bind(this.plot, "context", p, "context", plotContextConverter);
        ac.bind(this.plot, "background", p, "drawBackground");
        ac.bind(this.plot, "ephemerisLabels", p.getXAxis(), "tcaLabels");
        ac.bind(this.plot, "ephemerisLineCount", p.getXAxis(), "tcaRows");
    }

    protected void removeBindings() {
        ApplicationController ac = this.dom.controller;
        DasPlot p = this.dasPlot;
        ac.unbind(this.dom.options, "drawGrid", p, "drawGrid");
        ac.unbind(this.dom.options, "drawMinorGrid", p, "drawMinorGrid");
        ac.unbind(this.dom.options, "flipColorbarLabel", this.plot.getZaxis().getController().dasAxis, "flipLabel");
        ac.unbind(this.dom.options, "flipColorbarLabel", this.plot.getYaxis().getController().dasAxis, "flipLabel");
        ac.unbind(this.dom.options, "ticklen", p.getXAxis(), "tickLength");
        ac.unbind(this.dom.options, "ticklen", p.getYAxis(), "tickLength");
        ac.unbind(this.dom.options, "ticklen", this.dasColorBar, "tickLength");
        ac.unbind(this.dom.options, "oppositeAxisVisible", p.getXAxis(), "oppositeAxisVisible");
        ac.unbind(this.dom.options, "oppositeAxisVisible", p.getYAxis(), "oppositeAxisVisible");
        ac.unbind(this.dom.options, "lineThickness", p.getXAxis(), "lineThickness");
        ac.unbind(this.dom.options, "lineThickness", p.getYAxis(), "lineThickness");
        ac.unbind(this.dom.options, "lineThickness", this.dasColorBar, "lineThickness");
        ac.unbind(this.dom.options, "lineThickness", p, "lineThickness");
        ac.unbind(this.dom.options, "multiLineTextAlignment", p, "multiLineTextAlignment");
        ac.unbind(this.dom.options, "printingLogLevel", p, "printingLogLevel");
        ac.unbind(this.dom.options, "displayLogLevel", p, "logLevel");
        ac.unbind(this.dom.options, "logMessageTimeoutSec", p, "logTimeoutSec");
        ac.unbind(this.dom.options, "overRendering", p, "overSize");
        this.dom.options.removePropertyChangeListener("dayOfYear", this.dayOfYearListener);
        this.dom.options.removePropertyChangeListener("mouseModule", this.mouseModuleListener);
        this.plot.removePropertyChangeListener(this.plotListener);
        this.plot.xaxis.removePropertyChangeListener(this.plotListener);
        this.plot.xaxis.controller.removeBindings();
        this.plot.yaxis.controller.removeBindings();
        this.plot.zaxis.controller.removeBindings();
        this.plot.getXaxis().removePropertyChangeListener(this.autorangeListener);
        this.plot.getYaxis().removePropertyChangeListener(this.autorangeListener);
        this.plot.getZaxis().removePropertyChangeListener(this.autorangeListener);
        this.plot.removePropertyChangeListener("title", this.labelListener);
        this.plot.removePropertyChangeListener("ticksURI", this.ticksURIListener);
        this.plot.removePropertyChangeListener("ephemerisLabels", this.ticksURIListener);
        this.plot.removePropertyChangeListener("id", this.idListener);
        this.plot.removePropertyChangeListener("rowId", this.rowColListener);
        this.plot.removePropertyChangeListener("columnId", this.rowColListener);
        DasAxis a = p.getXAxis();
        a.removePropertyChangeListener(this.xaxisRangeListener);
        a.setPreviousAction("scan", null);
        a.setNextAction("scan", null);
        this.expertMenuItems = null;
        this.pdListen = null;
        this.titleConverter = null;
    }

    protected void removeReferences() {
        this.plot = null;
        this.dom = null;
        this.dasPlot = null;
        this.dasColorBar = null;
        this.pdListen = null;
    }

    public BindingModel[] getBindings() {
        return this.dom.controller.getBindingsFor(this.plot);
    }

    public BindingModel getBindings(int index) {
        return this.getBindings()[index];
    }

    public JMenuItem getPlotElementPropsMenuItem() {
        return this.plotElementPropsMenuItem;
    }

    public void setPlotElementPropsMenuItem(JMenuItem pelePropsMenuItem) {
        JMenuItem old = this.plotElementPropsMenuItem;
        this.plotElementPropsMenuItem = pelePropsMenuItem;
        this.propertyChangeSupport.firePropertyChange(PROP_PLOTELEMENTPROPSMENUITEM, old, pelePropsMenuItem);
    }

    public Application getApplication() {
        return this.dom;
    }

    public String toString() {
        return this.plot + " controller";
    }

    public void setTitleAutomatically(String title) {
        this.plot.setTitle(title);
        this.plot.setAutoLabel(true);
    }

    public void setExpertMenuItems(JMenuItem[] items) {
        this.expertMenuItems = Arrays.copyOf(items, items.length);
    }

    public JMenuItem[] getExpertMenuItems() {
        return Arrays.copyOf(this.expertMenuItems, this.expertMenuItems.length);
    }

    public void setExpertMode(boolean expert) {
        for (JMenuItem mi : this.expertMenuItems) {
            mi.setVisible(expert);
        }
    }

    public Row getRow() {
        return this.dom.canvases.get(0).getController().getRowFor(this.plot);
    }

    public Column getColumn() {
        return this.dom.canvases.get(0).getController().getColumnFor(this.plot);
    }

    private class MyFeedback
    implements DasMouseInputAdapter.Feedback {
        String myLastMessage = "";
        String otherLastMessage = "";

        private MyFeedback() {
        }

        public void setMessage(String message) {
            if (message.equals("")) {
                if (PlotController.this.getApplication().getController().getStatus().equals(this.myLastMessage)) {
                    PlotController.this.getApplication().getController().setStatus(this.otherLastMessage);
                }
            } else {
                this.otherLastMessage = PlotController.this.getApplication().getController().getStatus();
                PlotController.this.getApplication().getController().setStatus(message);
            }
            this.myLastMessage = message;
        }
    }
}

